/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.analysis.dpManager;

import ibm.nways.analysis.dpCommon.EventFilter;
import ibm.nways.analysis.dpCommon.PerformanceEvent;
import ibm.nways.analysis.dpManager.AppletNotifyInterface;
import ibm.nways.analysis.dpManager.EventRegistry;
import ibm.nways.analysis.dpManager.RegistryEvent;
import java.rmi.RemoteException;
import java.util.Vector;

class EventListener
implements Runnable {
    private AppletNotifyInterface appletObject;
    private EventRegistry eventRegistry;
    private Thread listenerThread;
    private long lastEventDate;
    private EventFilter theFilter;

    public EventListener(EventRegistry eventRegistry, AppletNotifyInterface appletNotifyInterface, EventFilter eventFilter) {
        this.eventRegistry = eventRegistry;
        this.appletObject = appletNotifyInterface;
        this.theFilter = eventFilter;
        this.listenerThread = new Thread(this);
        this.listenerThread.start();
    }

    public EventListener(EventRegistry eventRegistry, AppletNotifyInterface appletNotifyInterface) {
        this.eventRegistry = eventRegistry;
        this.appletObject = appletNotifyInterface;
        this.listenerThread = new Thread(this);
        this.listenerThread.start();
    }

    public AppletNotifyInterface getAppletObject() {
        return this.appletObject;
    }

    public void run() {
        try {
            Vector vector;
            if (this.theFilter != null && this.theFilter.getBeginTime() > -1L && (vector = this.eventRegistry.getEvents(this.theFilter)) != null && vector.size() > 0) {
                this.appletObject.updateEvent(vector);
            }
            while (true) {
                vector = this.eventRegistry.getEvent(this.eventRegistry.getCurrentEventDate());
                Vector<PerformanceEvent> vector2 = new Vector<PerformanceEvent>();
                int n = 0;
                while (n < vector.size()) {
                    PerformanceEvent performanceEvent = ((RegistryEvent)vector.elementAt(n)).getPerformanceEvent();
                    if (this.theFilter == null) {
                        vector2.addElement(performanceEvent);
                    } else if (this.theFilter.filter(performanceEvent, this.eventRegistry.getServer())) {
                        vector2.addElement(performanceEvent);
                    }
                    ++n;
                }
                if (vector2.size() > 0) {
                    this.appletObject.updateEvent(vector2);
                }
                this.lastEventDate = ((RegistryEvent)vector.lastElement()).getTimeReceived();
            }
        }
        catch (RemoteException remoteException) {
            this.eventRegistry.removeListener(this.appletObject);
            return;
        }
    }

    public void stop() {
        if (this.listenerThread != null) {
            this.listenerThread.stop();
            this.listenerThread = null;
        }
    }
}

